import usb.core
import usb.util

def list_printers():
    devices = usb.core.find(find_all=True)
    for dev in devices:
        vid = hex(dev.idVendor)
        pid = hex(dev.idProduct)
        print(f"usb://{vid}:{pid} - Device: {usb.util.get_string(dev, dev.iProduct)}")

if __name__ == '__main__':
    list_printers()
